﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;

public partial class Admin_NeiRong_YiDongLanMu : System.Web.UI.Page
{
    private 访问 访问;
    protected String 栏目类型;
    protected String 执行代码;
    protected String 栏目位置;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("移动栏目", "网站后台", "移动栏目", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            移动栏目();
        else
            初始化栏目();
    }

    private void 获取栏目(String 标题信息, out String 栏目类型, out int ID)
    {
        if (标题信息.StartsWith("w"))
        {
            栏目类型 = "文章";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else if (标题信息.StartsWith("t"))
        {
            栏目类型 = "图片";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else if (标题信息.StartsWith("r"))
        {
            栏目类型 = "软件";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else if (标题信息.StartsWith("y"))
        {
            栏目类型 = "音乐";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else if (标题信息.StartsWith("sa"))
        {
            栏目类型 = "商品";
            ID = Convert.ToInt32(标题信息.Substring(2));
        }
        else if (标题信息.StartsWith("s"))
        {
            栏目类型 = "视频";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
        else
        {
            栏目类型 = "小说";
            ID = Convert.ToInt32(标题信息.Substring(1));
        }
    }

    private void 初始化栏目()
    {
        String 标题信息 = Request.QueryString["ti"];
        String 栏目类型;
        int ID, 所属栏目;

        获取栏目(标题信息, out 栏目类型, out ID);
        this.栏目类型 = 栏目类型 + "栏目";

        SqlCommand 语句 = new SqlCommand("SELECT [所属栏目] FROM ["+程序.数据表前缀+"内容_栏目] WHERE [栏目类型]=@栏目类型 AND [ID]=@ID", 访问.连接);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = 栏目类型;
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
            所属栏目 = Convert.ToInt32(读取["所属栏目"]);
        else
        {
            读取.Close();
            throw new Exception("内容栏目不存在");
        }
        读取.Close();

        ListItem 顶级栏目 = new ListItem("顶级栏目", "0");
        顶级栏目.Selected = 所属栏目 == 0;
        FuLanMu.Items.Add(顶级栏目);

        DataSet 数据=new DataSet();
        语句 = new SqlCommand("SELECT [ID],[栏目名称],[所属栏目],[是否拥有子栏目] FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [栏目类型]=@栏目类型 AND [ID]<>@ID", 访问.连接);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = 栏目类型;
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "内容栏目");

        生成列表(数据, 0, 1,所属栏目);
    }

    private void 生成列表(DataSet 数据,int 父栏目, int 深度,int 所属栏目)
    {
        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
        {
            DataRow 行 = 数据.Tables[0].Rows[i];
            if (Convert.ToInt32(行["所属栏目"]) == 父栏目)
            {
                ListItem 列表项 = new ListItem(生成空格(深度) + Convert.ToString(行["栏目名称"]), Convert.ToString(行["ID"]));
                列表项.Selected=Convert.ToInt32(行["ID"]) == 所属栏目;
                列表项.Attributes["style"] = Convert.ToBoolean(行["是否拥有子栏目"]) ? "" : "background:#eeeeee";
                FuLanMu.Items.Add(列表项);
                生成列表(数据, Convert.ToInt32(行["ID"]), 深度 + 1, 所属栏目);
            }
        }
    }

    private String 生成空格(int 数量)
    {
        String 返回值 = "";
        for (int i = 0; i < 数量; i++)
            返回值 += "　";
        return 返回值+"|-";
    }

    private void 更新栏目状态(int 栏目)
    {
        if(栏目==0)
            return;

        SqlCommand 语句 = new SqlCommand("SELECT [ID] FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [所属栏目]=@所属栏目", 访问.连接);
        语句.Parameters.Add("@所属栏目",SqlDbType.Int).Value=栏目;
        SqlDataReader 读取=语句.ExecuteReader();
        bool 是否存在=读取.HasRows;
        读取.Close();

        语句 = new SqlCommand("UPDATE [" + 程序.数据表前缀 + "内容_栏目] SET [是否拥有子栏目]=@是否拥有子栏目 WHERE [ID]=" + 栏目, 访问.连接);
        语句.Parameters.Add("@是否拥有子栏目", SqlDbType.Bit).Value = 是否存在;
        语句.ExecuteNonQuery();
    }

    private void 移动栏目()
    {
        访问.验证权限("9");
        String 标题信息 = Request.QueryString["ti"];
        String 栏目类型;
        int ID, 所属栏目;

        获取栏目(标题信息, out 栏目类型, out ID);
        this.栏目类型 = 栏目类型 + "栏目";

        SqlCommand 语句 = new SqlCommand("SELECT [所属栏目] FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [栏目类型]=@栏目类型 AND [ID]=@ID", 访问.连接);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = 栏目类型;
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
            所属栏目 = Convert.ToInt32(读取["所属栏目"]);
        else
        {
            读取.Close();
            throw new Exception("内容栏目不存在");
        }
        读取.Close();

        语句 = new SqlCommand("UPDATE [" + 程序.数据表前缀 + "内容_栏目] SET [所属栏目]=@所属栏目 WHERE [栏目类型]=@栏目类型 AND [ID]=@ID", 访问.连接);
        语句.Parameters.Add("@所属栏目", SqlDbType.Int).Value = Convert.ToInt32(FuLanMu.SelectedValue);
        语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = 栏目类型;
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        语句.ExecuteNonQuery();

        更新栏目状态(所属栏目);
        更新栏目状态(Convert.ToInt32(FuLanMu.SelectedValue));
        更新缓存数据 更新缓存 = new 更新缓存数据(this.Context, 访问.连接);
        更新缓存.内容栏目_更新();

        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("转移栏目[" + ID + "]", 访问.用户["昵称"].ToString());

        执行代码 = "window.open('../DH_NeiRongGuanLi.aspx','ZuoDaoHang');" +
            "location.href='FenLeiNeiRongLieBiao.aspx?ID=" + ID + "';";
    }
}
